package easik.sketch.util.graph;

/**
 * A cell factory class for the Easik application.
 * 
 * @author William Belanger 2006
 * @author Kevin Green 2006
 * @since 2006-07-25 Kevin Green
 * @version 2006-07-25 Kevin Green
 */
public class EasikCellViewFactory extends ExtendableCellViewFactory {

	/**
	 * Default constructor adds entity cells to the list of mappings.
	 */
	public EasikCellViewFactory(){
		super();
		addEntityCell();
	}
	/**
	 * Adds entity cells to the list of mappings.
	 */
	protected void addEntityCell(){
		addCellType(EntityCell.class, EntityView.class);
	}
}
